Collisions = {}
CO = {}

function Collisions.newObject (cl, scr, x, y, x2, y2, mode)
  CO[cl] = {}
  
  CO[cl].x = x
  CO[cl].y = y
  CO[cl].x2 = x2
  CO[cl].y2 = y2
  
  CO[cl].scr = scr
  
  CO[cl].mode = mode
  
  CO[cl].isInCollision = false
  CO[cl].inCollisionWith = 0
  CO[cl].collisionMode = ""
end

function Collisions.drawObject (cl, two)
  if CO[cl].mode == "Rect" then
    screen.drawRect (CO[cl].scr, CO[cl].x, CO[cl].y, CO[cl].x2, CO[cl].y2, two)
  elseif CO[cl].mode == "FillRect" then
    screen.drawFillRect (CO[cl].scr, CO[cl].x, CO[cl].y, CO[cl].x2, CO[cl].y2, two)
  elseif CO[cl].mode == "GradientRect" then
    screen.drawGradientRect (CO[cl].scr, CO[cl].x, CO[cl].y, CO[cl].x2, CO[cl].y2, two)
  elseif CO[cl].mode == "Image" then
    screen.blit (CO[cl].scr, CO[cl].x, CO[cl].y, two)
  end
end

function Collisions.initCollision (one, two)
 if CO[one].x2 == CO[two].x and CO[one].y <= CO[two].y2 and CO[one].y >= CO[two].y then
    CO[one].isInCollision = true
    CO[one].inCollisionWith = two
    CO[one].collisionMode = "right"
    CO[two].isInCollison = true
    CO[two].inCollisionWith = one
    CO[two].collisionMode = "left"
  elseif CO[one].x == CO[two].x2 and CO[one].y <= CO[two].y2 and CO[one].y2 >= CO[two].y then
    CO[one].isInCollision = true
    CO[one].inCollisionWith = two
    CO[one].collisionMode = "left"
    CO[two].isInCollison = true
    CO[two].inCollisionWith = one
    CO[two].collisionMode = "right"
  elseif CO[one].y == CO[two].y2 and CO[one].x >= CO[two].x and CO[one].x2 <= CO[two].x2 then 
    CO[one].isInCollision = true
    CO[one].inCollisionWith = two
    CO[one].collisionMode = "up"
    CO[two].isInCollison = true
    CO[two].inCollisionWith = one
    CO[two].collisionMode = "down"
  elseif CO[one].y2 == CO[two].y and CO[one].x >= CO[two].x and CO[one].x2 <= CO[two].x2 then
    CO[one].isInCollision = true
    CO[one].inCollisionWith = two
    CO[one].collisionMode = "down"
    CO[two].isInCollison = true
    CO[two].inCollisionWith = one
    CO[two].collisionMode = "up"
  else
    CO[one].isInCollision = false
    CO[one].inCollisionWith = 0
    CO[one].collisionMode = ""
    CO[two].isInCollison = false
    CO[two].inCollisionWith = 0
    CO[two].collisionMode = ""
  end
	
  if CO[one].x2 == CO[two].x and CO[one].y2 >= CO[two].y and CO[one].y <= CO[two].y2 then
    CO[one].isInCollision = true
    CO[one].inCollisionWith = two
    CO[one].collisionMode = "right"
    CO[two].isInCollison = true
    CO[two].inCollisionWith = one
    CO[two].collisionMode = "left"
	end
	
	if CO[one].y == CO[two].y2 and CO[one].x2 >= CO[two].x and CO[one].x <= CO[two].x2 then 
    CO[one].isInCollision = true
    CO[one].inCollisionWith = two
    CO[one].collisionMode = "up"
    CO[two].isInCollison = true
    CO[two].inCollisionWith = one
    CO[two].collisionMode = "down"
	end
	
	if CO[one].y2 == CO[two].y and CO[one].x2 >= CO[two].x and CO[one].x <= CO[two].x2 then
    CO[one].isInCollision = true
    CO[one].inCollisionWith = two
    CO[one].collisionMode = "down"
    CO[two].isInCollison = true
    CO[two].inCollisionWith = one
    CO[two].collisionMode = "up"
	end
end

function Collisions.isInCollision (cl)
  return CO[cl].isInCollision
end

function Collisions.isInCollisionWith (one, two)
  local ret = false
  
  if CO[one].inCollisionWith == two then
    ret = true
  else
    ret = false
  end
  
  return ret
end

function Collisions.update (cl, x, y, x2, y2)
  CO[cl].x = x
  CO[cl].y = y
  CO[cl].x2 = x2
  CO[cl].y2 = y2
end

function Collisions.mode (cl)
  return CO[cl].collisionMode
end

function Collisions.destroyObject (cl)
  _G[cl] = nil
end

-- bold
function screen.printB (scr, x, y, texte, color)
  if color == nil then color = Color.new (31, 31, 31) end
  screen.print (scr, x, y, texte, color)
  screen.print (scr, x+1, y, texte, color)
end

-- underlined
function screen.printU (scr, x, y, texte, color)
  if color == nil then color = Color.new (31, 31, 31) end
  screen.print (scr, x, y, texte, color)
  if texte~=nil or texte~="" then
    local txtnum = string.len (texte)
    local x2 = x+txtnum*6
    screen.drawLine (scr, x, y+10, x2, y+10, color)
  end
end

-- strike
function screen.printS (scr, x, y, texte, color)
  if color == nil then color = Color.new (31, 31, 31) end
  screen.print (scr, x, y, texte, color)
  if texte~=nil or texte~="" then
    local txtnum = string.len (texte)
    local x2 = x+txtnum*6
    screen.drawLine (scr, x, y+4, x2, y+4, color)
  end
end

function newBox(x1, y1, x2, y2)
   Box = { }
   Box.x1 = x1
   Box.y1 = y1
   Box.x2 = x2
   Box.y2 = y2
   return Box
end

function Stylus.newPressinBox(Box, x, y)
   local ret = false
   if Stylus.newPress then
   if x > Box.x1 and x < Box.x2 and y > Box.y1 and y < Box.y2 then ret = true end
   return ret
   end
end

function Stylus.heldinBox(Box, x, y)
   local ret = false
   if Stylus.held then
   if x > Box.x1 and x < Box.x2 and y > Box.y1 and y < Box.y2 then ret = true end
   return ret
   end
end

function Stylus.doubleClickinBox(Box, x, y)
   local ret = false
   if Stylus.doubleClick then
   if x > Box.x1 and x < Box.x2 and y > Box.y1 and y < Box.y2 then ret = true end
   return ret
   end
end

----------------------------------------------
c_blanc = Color.new (31, 31, 31)
c_rouge = Color.new (31, 0, 0)
c_vert = Color.new (0, 31, 0)
c_bleu = Color.new (0, 0, 31)
c_noir = Color.new (0, 0, 0)
----------------------------------------------
function Color.mod (rg, ve, bl)
  local rouge = rg*31/255
  local vert = ve*31/255
  local bleu = bl*31/255
  local R = math.floor (rouge)
  local V = math.floor (vert)
  local B = math.floor (bleu)
  return Color.new (R, V, B)
end
----------------------------------------------
c_gris = Color.mod (128, 128, 128)
c_orange = Color.mod (255, 127, 39)
c_jaune = Color.mod (255, 255, 0)
c_saumon = Color.mod (255, 128, 128)
c_kaki = Color.mod (0, 128, 0)
c_vertclair = Color.mod (128, 255, 0)
c_bleuciel = Color.mod (128, 255, 255)
c_bleuclair = Color.mod (0, 255, 255)
c_rose = Color.mod (255, 0, 255)
c_roseclair = Color.mod (255, 128, 255)
c_griswin = Color.mod (240, 240, 240)
c_grisclair = Color.mod (192, 192, 192)
--- complter---

function Color.invert (r, g, b)
  if r > 31 then
    Color.inversMod (r, g, b)
  else
    Color.invers (r, g, b)
  end
end
-- Inversion par aurel2108 --
function Color.inversMod (rg, ve, bl)
  local rouge = 255 - rg
  local vert = 255 - ve
  local bleu = 255 - bl
  
  return Color.mod (rouge, vert, bleu)
end
-------------------------------
function Color.invers (rg, ve, bl)
  local rouge = 31 - rg
  local vert = 31 - ve
  local bleu = 31 - bl
  
  return Color.new (rouge, vert, bleu)
end
----------------------------------------------

function screen.drawDisc(screendisc, xdisc,ydisc, rayondisc, couleurdisc)
	a=0
	while a < (math.rad(360/4)) do
		screen.drawFillRect(screendisc, xdisc, ydisc, (math.cos(a)*rayondisc) + xdisc, -(math.sin(a)*rayondisc) + ydisc, couleurdisc)
		screen.drawFillRect(screendisc, xdisc, ydisc, (math.cos(a)*rayondisc) + xdisc, (math.sin(a)*rayondisc) + ydisc, couleurdisc)
		screen.drawFillRect(screendisc, xdisc, ydisc, -(math.cos(a)*rayondisc) + xdisc, -(math.sin(a)*rayondisc) + ydisc, couleurdisc)
		screen.drawFillRect(screendisc, xdisc, ydisc, -(math.cos(a)*rayondisc) + xdisc, (math.sin(a)*rayondisc) + ydisc, couleurdisc)
		a = a + 0.01
	end
end

function screen.drawCercle(screendisc, xdisc,ydisc, rayondisc, couleurdisc)
	a=0
	while a < (math.rad(360/4)) do
		screen.drawLine(screendisc, (math.cos(a-0.005)*rayondisc) + xdisc, -(math.sin(a-0.005)*rayondisc) + ydisc, (math.cos(a)*rayondisc) + xdisc, -(math.sin(a)*rayondisc) + ydisc, couleurdisc)
		screen.drawLine(screendisc, (math.cos(a-0.005)*rayondisc) + xdisc, (math.sin(a-0.005)*rayondisc) + ydisc, (math.cos(a)*rayondisc) + xdisc, (math.sin(a)*rayondisc) + ydisc, couleurdisc)
		screen.drawLine(screendisc, -(math.cos(a-0.005)*rayondisc) + xdisc, -(math.sin(a-0.005)*rayondisc) + ydisc, -(math.cos(a)*rayondisc) + xdisc, -(math.sin(a)*rayondisc) + ydisc, couleurdisc)
		screen.drawLine(screendisc, -(math.cos(a-0.005)*rayondisc) + xdisc, (math.sin(a-0.005)*rayondisc) + ydisc, -(math.cos(a)*rayondisc) + xdisc, (math.sin(a)*rayondisc) + ydisc, couleurdisc)
		a = a + 0.01
	end
end

function screen.drawSoftRect(screensr, xsra, ysra, xsrb, ysrb, couleursr)
	if (xsrb-xsra) > (ysrb-ysra) then
		rayonsr = math.floor((xsrb-xsra)*10/100)
	else
		rayonsr = math.floor((ysrb-ysra)*10/100)
	end
	a=0
	screen.drawFillRect(screensr, xsra+rayonsr, ysra, xsrb-rayonsr, ysrb, couleursr)
	screen.drawFillRect(screensr, xsra, ysra+rayonsr, xsrb, ysrb-rayonsr, couleursr)
	while a < (math.rad(360/4)) do
		screen.drawFillRect(screensr, xsrb-rayonsr, ysra+rayonsr, (math.cos(a)*rayonsr) + xsrb-rayonsr, -(math.sin(a)*rayonsr) + ysra+rayonsr, couleursr)
		screen.drawFillRect(screensr, xsrb-rayonsr, ysrb-rayonsr, (math.cos(a)*rayonsr) + xsrb-rayonsr, (math.sin(a)*rayonsr) + ysrb-rayonsr, couleursr)
		screen.drawFillRect(screensr, xsra+rayonsr, ysra+rayonsr, -(math.cos(a)*rayonsr) + xsra+rayonsr, -(math.sin(a)*rayonsr) + ysra+rayonsr, couleursr)
		screen.drawFillRect(screensr, xsra+rayonsr, ysrb-rayonsr, -(math.cos(a)*rayonsr) + xsra+rayonsr, (math.sin(a)*rayonsr) + ysrb-rayonsr, couleursr)
		a = a + 0.01
	end
end

function screen.drawEllipse(screenellipse, xellipse, yellipse, rayonellipsea, rayonellipseb, couleurellipse)
	a=0
	while a < (math.rad(360/4)) do
		screen.drawLine(screenellipse, (math.cos(a-0.005)*rayonellipsea) + xellipse, -(math.sin(a-0.005)*rayonellipseb) + yellipse, (math.cos(a)*rayonellipsea) + xellipse, -(math.sin(a)*rayonellipseb) + yellipse, couleurellipse)
		screen.drawLine(screenellipse, (math.cos(a-0.005)*rayonellipsea) + xellipse, (math.sin(a-0.005)*rayonellipseb) + yellipse, (math.cos(a)*rayonellipsea) + xellipse, (math.sin(a)*rayonellipseb) + yellipse, couleurellipse)
		screen.drawLine(screenellipse, -(math.cos(a-0.005)*rayonellipsea) + xellipse, -(math.sin(a-0.005)*rayonellipseb) + yellipse, -(math.cos(a)*rayonellipsea) + xellipse, -(math.sin(a)*rayonellipseb) + yellipse, couleurellipse)
		screen.drawLine(screenellipse, -(math.cos(a-0.005)*rayonellipsea) + xellipse, (math.sin(a-0.005)*rayonellipseb) + yellipse, -(math.cos(a)*rayonellipsea) + xellipse, (math.sin(a)*rayonellipseb) + yellipse, couleurellipse)
		a = a + 0.01
	end
end

function screen.drawFillEllipse(screenellipse, xellipse, yellipse, rayonellipsea, rayonellipseb, couleurellipse)
	a=0
	while a < (math.rad(360/4)) do
		screen.drawFillRect(screenellipse, xellipse, yellipse, (math.cos(a)*rayonellipsea) + xellipse, -(math.sin(a)*rayonellipseb) + yellipse, couleurellipse)
		screen.drawFillRect(screenellipse, xellipse, yellipse, (math.cos(a)*rayonellipsea) + xellipse, (math.sin(a)*rayonellipseb) + yellipse, couleurellipse)
		screen.drawFillRect(screenellipse, xellipse, yellipse, -(math.cos(a)*rayonellipsea) + xellipse, -(math.sin(a)*rayonellipseb) + yellipse, couleurellipse)
		screen.drawFillRect(screenellipse, xellipse, yellipse, -(math.cos(a)*rayonellipsea) + xellipse, (math.sin(a)*rayonellipseb) + yellipse, couleurellipse)
		a = a + 0.01
	end
end

function screen.drawCrossRect(screencr, xcra, ycra, xcrb, ycrb, couleurcr)
	if (xcrb-xcra) > (ycrb-ycra) then
		rayoncr = math.floor((xcrb-xcra)*10/100)
	else
		rayoncr = math.floor((ycrb-ycra)*10/100)
	end
	screen.drawFillRect(screencr, xcra+rayoncr, ycra, xcrb-rayoncr, ycrb, couleurcr)
	screen.drawFillRect(screencr, xcra, ycra+rayoncr, xcrb, ycrb-rayoncr, couleurcr)
end

function screen.drawJewelRect(screenjr, xjra, yjra, xjrb, yjrb, couleurjr)
	if (xjrb-xjra) > (yjrb-yjra) then
		rayonjr = math.floor((xjrb-xjra)*10/100)
	else
		rayonjr = math.floor((yjrb-yjra)*10/100)
	end
	a=0
	screen.drawFillRect(screenjr, xjra+rayonjr, yjra, xjrb-rayonjr, yjrb, couleurjr)
	screen.drawFillRect(screenjr, xjra, yjra+rayonjr, xjrb, yjrb-rayonjr, couleurjr)
	while a < rayonjr do
		screen.drawLine(screenjr, xjra+a, yjra+rayonjr, xjra+rayonjr, yjra+a, couleurjr)
		screen.drawLine(screenjr, xjrb-a, yjra+rayonjr, xjrb-rayonjr, yjra+a, couleurjr)
		screen.drawLine(screenjr, xjra+a, yjrb-rayonjr, xjra+rayonjr, yjrb-a, couleurjr)
		screen.drawLine(screenjr, xjrb-rayonjr, yjrb-a, xjrb-a, yjrb-rayonjr, couleurjr)
		a = a + 0.1
	end
end

function screen.drawRomanRect(screenrr, xrra, yrra, xrrb, yrrb, couleurrr)
	if (xrrb-xrra) > (yrrb-yrra) then
		rayonrr = math.floor((xrrb-xrra)*10/100)
	else
		rayonrr = math.floor((yrrb-yrra)*10/100)
	end
	a=0
	screen.drawFillRect(screenrr, xrra+rayonrr, yrra, xrrb-rayonrr, yrrb, couleurrr)
	screen.drawFillRect(screenrr, xrra, yrra+rayonrr, xrrb, yrrb-rayonrr, couleurrr)
	while a < (math.rad(360/4)) do
		screen.drawFillRect(screenrr, (xrra+rayonrr), (yrrb-rayonrr), (xrra+rayonrr)-rayonrr+(math.cos(a)*rayonrr),(yrrb-rayonrr)+rayonrr-(math.sin(a)*rayonrr), couleurrr) --bas gauche
		screen.drawFillRect(screenrr, (xrra+rayonrr), (yrra+rayonrr), (xrra+rayonrr)-rayonrr+(math.cos(a)*rayonrr),(yrra+rayonrr)-rayonrr+(math.sin(a)*rayonrr), couleurrr) --haut gauche
		screen.drawFillRect(screenrr, (xrrb-rayonrr), (yrrb-rayonrr), (xrrb-rayonrr)+rayonrr-(math.cos(a)*rayonrr),(yrrb-rayonrr)+rayonrr -(math.sin(a)*rayonrr), couleurrr) --bas droite
		screen.drawFillRect(screenrr, (xrrb-rayonrr), (yrra+rayonrr),(xrrb-rayonrr)+rayonrr -(math.cos(a)*rayonrr),(yrra+rayonrr)-rayonrr+ (math.sin(a)*rayonrr), couleurrr) --haut droite
		a = a + 0.01
	end
end

-- Library by Risike

-- Trim a string
function stringTrim(s)
	assert(s ~= nil, "String can't be nil")
	return (string.gsub(s, "^%s*(.-)%s*$", "%1"))
end

INI = {}

-- Save a table into an INI file
-- path: path of the file to write
-- tab: table to save
INI.save = function(path, tab)
	assert(path ~= nil, "Path can't be nil")
	assert(type(tab) == "table", "Second parameter must be a table")
	local f = io.open(path, "w")
	local i = 0
	for key, value in pairs(tab) do
		if i ~= 0 then
			f:write("\n")
		end
		f:write("["..key.."]".."\n")
		for key2, value2 in pairs(tab[key]) do
			key2 = stringTrim(key2)
			value2 = stringTrim(value2)
			key2 = key2:gsub(";", "\\;")
			key2 = key2:gsub("=", "\\=")
			value2 = value2:gsub(";", "\\;")
			value2 = value2:gsub("=", "\\=")	
			f:write(key2.."="..value2.."\n")
		end
		i = i + 1
	end
	f:close()
end

-- Load an INI file
-- path: path of the file to read
INI.load = function(path)
	assert(path ~= nil, "Path can't be nil")
	local f = io.open(path, "r")
	local tab = {}
	local line = ""
	local newLine
	local i
	local currentTag = nil
	local found = false
	local pos = 0
	while line ~= nil do
		found = false		
		line = line:gsub("\\;", "#_!36!_#") -- to keep \;
		line = line:gsub("\\=", "#_!71!_#") -- to keep \=
		if line ~= "" then
			-- Delete comments
			newLine = line
			line = ""
			for i=1, string.len(newLine) do				
				if string.sub(newLine, i, i) ~= ";" then
					line = line..newLine:sub(i, i)						
				else				
					break
				end
			end
			line = stringTrim(line)
			-- Find tag			
			if line:sub(1, 1) == "[" and line:sub(line:len(), line:len()) == "]" then
				currentTag = stringTrim(line:sub(2, line:len()-1))
				tab[currentTag] = {}
				found = true							
			end
			-- Find key and values
			if not found and line ~= "" then				
				pos = line:find("=")				
				if pos == nil then
					error("Bad INI file structure")
				end
				line = line:gsub("#_!36!_#", ";")
				line = line:gsub("#_!71!_#", "=")
				tab[currentTag][stringTrim(line:sub(1, pos-1))] = stringTrim(line:sub(pos+1, line:len()))
				found = true			
			end			
		end
		line = f:read("*line")		
	end
	f:close()
	return tab
end

